<?php

class SociablePro extends Sociable {
	function SociablePro() {
		parent::Sociable();

		// Add additional icon sets
		$this->iconsets = Array(
			'custom' => array('description' => 'Custom', 'path' => '/images/custom/', 'sizes' => array(16, 32, 48, 64)),
			'default' => array('description' => 'Default', 'path' => '/images/default/', 'sizes' => array(16)),
			'circular' => array('description' => 'Circular', 'path' => '/pro/images/circular/', 'sizes' => array(32, 64)),
			'handycons' => array('description' => 'Handy', 'path' => '/pro/images/handycons/', 'sizes' => array(16, 32, 64)),
			'hearting' => array('description' => 'Heart', 'path' => '/pro/images/hearting/', 'sizes' => array(16, 32, 64)),
			'komodo' => array('description' => 'Komodo', 'path' => '/pro/images/komodo/', 'sizes' => array(16, 32)),
			'pagepeel' => array('description' => 'Pagepeel', 'path' => '/pro/images/pagepeel/', 'sizes' => array(64)),
			'follow' => array('description' => 'Follow', 'path' => '/pro/images/follow/', 'sizes' => array(16, 24, 32, 48, 60)),
			'social_me' => array('description' => 'SocialMe', 'path' => '/pro/images/social_me/', 'sizes' => array(16, 24, 48, 64)),
			'stamps' => array('description' => 'Stamps', 'path' => '/pro/images/stamps/', 'sizes' => array(32, 64)),
			'studiom6' => array('description' => 'Studio M6', 'path' => '/pro/images/studiom6/', 'sizes' => array(16, 32, 64)),
			'tydlinka' => array('description' => 'Tydlinka', 'path' => '/pro/images/tydlinka/', 'sizes' => array(16, 32, 64)),
			'webtoolkit' => array('description' => 'Webtoolkit', 'path' => '/pro/images/webtoolkit/', 'sizes' => array(24, 32, 48, 62)),
		);

		$this->version .= ' PRO';

		// Block repository updates
		add_filter( 'site_transient_update_plugins', array(&$this, 'update_plugins'));
	}


	// Block repository updates
	function update_plugins($value) {
		if (isset($value->response[$this->basename])) {
			unset($value->response[$this->basename]->package);
			if (!has_filter( "after_plugin_row_$this->basename" ))
				add_filter("after_plugin_row_$this->basename", array(&$this, 'after_plugin_row'), 20);
		}
		return $value;
	}

	function after_plugin_row($value) {
		$title = __('Sociable Home Page');
		echo '<tr class="plugin-update-tr"><td colspan="3" class="plugin-update"><div class="update-message">';
		echo "A Sociable PRO Version update is available at the <a href='$this->homepage' title='$title'>$title</a>";
		echo '</div></td></tr>';
	}

	function options_header() {
	}

	function set_iconset_name() {
		$options = get_option('sociable');
		$iconset_name = (isset($options['iconset_name'])) ? $options['iconset_name'] : 'default';
		$icon_size = (isset($options['icon_size'])) ? $options['icon_size'] : 16;

		echo "<select id='sociable_iconset_name' name='sociable[iconset_name]'>";
		foreach ((array)$this->iconsets as $name => $iconset) {
			$iconset  = (object)$iconset;
			foreach($iconset->sizes as $size) {
				$selected = ( $iconset_name == $name && $icon_size == $size ) ? "selected='selected'" : "";
				$value = esc_attr("$name:$size");
				$description = esc_attr($iconset->description . "($size x $size)");
				echo "<option value='$value' $selected>$description</option>";
			}
		}
		echo "</select>";
		echo "<br/>" . __("To use custom icons put them in the <code>/images/custom/size</code> directory.  For example <code>/images/custom/16</code> for 16x16 icons. Make sure your icons have exactly the same name as the ones that come with Sociable.", 'sociable3');
	}

	function set_tooltips() {
		$options = get_option('sociable');
		$checked = (isset($options['tooltips'])) ? 'checked="checked"' : "";

		echo "<input type='checkbox' name='sociable[tooltips]' $checked />";
		_e("Check to display Sociable CSS tooltips instead of standard browser tooltips.", 'sociable3');
	}

	function set_facebook() {
		$options = get_option('sociable');
		$fb_like = (isset($options['fb_like'])) ? $options['fb_like'] : null;
		$fb_like_layout = (isset($options['fb_like_layout'])) ? $options['fb_like_layout'] : 'standard';
		$fb_colorscheme = (isset($options['fb_colorscheme'])) ? $options['fb_colorscheme'] : 'light';

		$fb_help_link ="<a href='http://developers.facebook.com/docs/guides/web'>" . __("default settings", 'sociable3') . "</a>";

		$checked = ($fb_like) ? 'checked="checked"' : "";
		echo "<input type='checkbox' name='sociable[fb_like]' $checked />";
		echo sprintf(__("Display a Facebook 'like' button above the other icons "), $fb_help_link);

		echo "<br/>";
		echo __("Button type ");
		echo "<select name='sociable[fb_like_layout]'>";
		echo "<option value='standard'>" . __("Standard button", 'sociable3') . "</option>";
		$selected = ($fb_like_layout == 'standard_faces') ? " selected " : "";
		echo "<option value='standard_faces' $selected>" . __("Standard button with faces", 'sociable3') . "</option>";
		$selected = ($fb_like_layout == 'button_count') ? " selected " : "";
		echo "<option value='button_count' $selected>" . __("Small button", 'sociable3') . "</option>";
		echo "</select>";

		echo "<br/>";
		echo __("Color scheme ");
		echo "<select name='sociable[fb_colorscheme]'>";
		echo "<option value='light'>" . __("Light button with dark text", 'sociable3') . "</option>";
		$selected = ($fb_colorscheme == 'dark') ? " selected " : "";
		echo "<option value='dark' $selected>" . __("Dark button with light text", 'sociable3') . "</option>";
		echo "</select>";
	}

	function set_bitly() {
		$options = get_option('sociable');
		$bitly_login = (isset($options['bitly_login'])) ? $options['bitly_login'] : null;
		$bitly_apikey = (isset($options['bitly_apikey'])) ? $options['bitly_apikey'] : null;

		$bitly_link = "<a href='http://www.bitly.com'>bit.ly</a>";
		echo sprintf( __("To shorten your Twitter links, enter your %s login and API key:", 'sociable3'), $bitly_link);
		echo "<br/>";
		echo __('Login', 'sociable3') . " <input type='text' name='sociable[bitly_login]' value='$bitly_login' size='12' />";
		echo __('API Key', 'sociable3') . " <input type='text' name='sociable[bitly_apikey]' value='$bitly_apikey' size='35' />";
		echo "<br/><br/>";
		echo __("Bitly URLs are saved for each post.  Click to clear the cache if you've changed your permalinks: ");
		echo "<span class='submit'><input name='clear_bitly' value='" . __("Clear cached data", 'sociable3') . "' type='submit'/></span>";;
	}

	function get_facebook_iframe($permalink) {
		$options = get_option('sociable');
		$fb_like = (isset($options['fb_like'])) ? $options['fb_like'] : null;
		$fb_like_layout = (isset($options['fb_like'])) ? $options['fb_like_layout'] : 'standard';
		$fb_colorscheme = (isset($options['fb_colorscheme'])) ? $options['fb_colorscheme'] : 'light';

		if (!$fb_like)
			return "";

		// No iframes for feeds
		if (is_feed())
			return "";

		$class = ($fb_like_layout == 'standard') ? 'sociable-fb-standard' : 'sociable-fb-button-count';
		switch ($fb_like_layout) {
			case 'standard':
				$class = 'sociable-fb-standard';
				$fb_show_faces = 'false';
				break;
			case 'standard_faces':
				$class = 'sociable-fb-standard-faces';
				$fb_show_faces = 'true';
				break;
			default:
				$class = 'sociable-fb-button-count';
				$fb_show_faces = 'false';
		}


		// Parameters: http://developers.facebook.com/docs/reference/plugins/like
		$fb_html = "<iframe src='http://www.facebook.com/plugins/like.php?href=PERMALINK&layout=$fb_like_layout&colorscheme=$fb_colorscheme&show_faces=$fb_show_faces' scrolling='no' allowTransparency='true' frameborder='0' class='$class'></iframe>";

		$iframe = str_replace('PERMALINK', $permalink, $fb_html);
		return "<div>$iframe</div>";
	}

	function get_bitly_permalink($post_id, $login, $apikey) {
		// If bitly was used before for this post and the permalink hasn't changed, then just return the existing short url
		$saved_data = get_post_meta($post_id, '_sociable_bitly', true);
		if ($saved_data && $saved_data['long_url'] == get_permalink($post_id) && $saved_data['url'])
			return $saved_data['url'];

		$permalink = get_permalink($post_id);

		$result = $this->get_bitly_url($permalink, $login, $apikey);
		$status_code = $result['status_code'];

		// Error
		if($status_code != 200 && $status_code != '200')
			return $permalink;

		// Success
		$data = $result['data'];
		update_post_meta($post_id, '_sociable_bitly', $data);
		return $data['url'];
	}

	function get_bitly_url($url, $login, $apikey) {
		$request_url = "http://api.bit.ly/v3/shorten?login=$login&apiKey=$apikey&longUrl=$url&format=json";
		$request = wp_remote_request($request_url, array('method' => 'GET'));
		$response = wp_remote_retrieve_response_code($request);

		$result = json_decode(wp_remote_retrieve_body($request), true);
		return $result;
	}

	function clear_bitly_data() {
		global $wpdb;
		$wpdb->query("delete from $wpdb->postmeta where meta_key = '_sociable_bitly'");
	}


	function get_icon_path($iconset_name=null, $icon_size=null) {
		$options = get_option('sociable');

		if (!$iconset_name)
			$iconset_name = (isset($options['iconset_name'])) ? $options['iconset_name'] : 'default';
		if (!$icon_size)
			$icon_size = (isset($options['icon_size'])) ? $options['icon_size'] : 16;

		$iconset = (isset($this->iconsets[$iconset_name])) ? (object)$this->iconsets[$iconset_name] : null;

		$path = (isset($iconset->path)) ? $iconset->path : '/images/default/';
		$path .= $icon_size . "/";
		return $path;
	}
}
?>
